g_saveStateZyliaID = undefined;

function fastSave(){
	
	var file = new CryptRawFile();
	
	file.open("fastsave.dat",true);
	
	file.write(g_maincharacter);
		
	party.save(file);
	worldtime.save(file);
	g_Boxes.save(file);
	objectsystem.save(file);
	
	
	if(IsMapEngineRunning()){
		file.write(GetCurrentMap());
		for(var i=0;i<party.members.length;i++){
			if(party.members[i].name==g_maincharacter){
				file.write(GetPersonX(party.members[i].name));
				file.write(GetPersonY(party.members[i].name));
				file.write(GetPersonDirection(party.members[i].name));
				}
			}
		}
	
	
	
	file.close();

	}

function SaveGame(filename){
	
	var file = new CryptRawFile();
	
	file.open(filename,true);
	
	file.write(g_maincharacter);
	file.write(GetTime()-startTime);
	file.write(g_money);	
	
	party.save(file);
	worldtime.save(file);
	g_Boxes.save(file);
	objectsystem.save(file);
	zyliasystem.save(file);
	kristallgeistsystem.save(file);
	musicmanager.save(file);
	
	if(IsMapEngineRunning()){
		file.write(GetCurrentMap());
		for(var i=0;i<party.members.length;i++){
			if(party.members[i].name==g_maincharacter){
				file.write(GetPersonX(party.members[i].name));
				file.write(GetPersonY(party.members[i].name));
				file.write(GetPersonDirection(party.members[i].name));
				}
			}
		}
	
	file.close();

	}
	
function fastLoad(){
	
	var file = new CryptRawFile();
	
	file.open("fastsave.dat",false);
	
	g_maincharacter = file.readString();
	
	party.load(file);
	worldtime.load(file);
	g_Boxes.load(file);
	objectsystem.load(file);
	
	if(IsMapEngineRunning()){
		ChangeMap(file.readString());
		for(var i=0;i<party.members.length;i++){
			if(party.members[i].name==g_maincharacter){
				CreatePerson(party.members[i].name,party.members[i].charset,false);
				AttachCamera(party.members[i].name);
				personcontroller.addInputProfile(party.members[i].name,createStandardMovement(party.members[i].name,btn_UP,btn_DOWN,btn_LEFT,btn_RIGHT,btn_OK,btn_CANCEL));
				SetPersonX(party.members[i].name,file.readInt());
				SetPersonY(party.members[i].name,file.readInt());
				SetPersonDirection(party.members[i].name,file.readString())
				}
			}
		}
	
	
	file.close();

	}
	
function LoadGame(filename){
	
	//AlteDatenZerstren
	renderscript.clear();
	var tmplist=GetPersonList();
	for(var i=0;i<tmplist.length;i++){
		DestroyPerson(tmplist[i]);
		}
	delete personcontroller;
	personcontroller = new PersonController();
	renderscript.add("controls","personcontroller.checkInput();");
	
	delete enemysystem;
	enemysystem = new EnemySystem();
	renderscript.add("enemysystem","enemysystem.update();");
	
	g_lastControledFrameSkip=GetTime();
renderscript.add("frameratecontrol","while(g_lastControledFrameSkip+14>GetTime());g_lastControledFrameSkip=GetTime();");
	
	
	
	GarbageCollect();
	
	var file = new CryptRawFile();
	
	file.open(filename,false);
	
	g_maincharacter = file.readString();
	startTime = GetTime()-file.readInt();
	g_money = file.readInt();
	
	party.load(file);
	worldtime.load(file);
	g_Boxes.load(file);
	objectsystem.load(file);
	zyliasystem.load(file);
	kristallgeistsystem.load(file);
	musicmanager.load(file);
	
	if(IsMapEngineRunning()){
		ChangeMap(file.readString());
		for(var i=0;i<party.members.length;i++){
			if(party.members[i].name==g_maincharacter){
				CreatePerson(party.members[i].name,party.members[i].charset,false);
				AttachCamera(party.members[i].name);
				SetPersonX(party.members[i].name,file.readInt());
				SetPersonY(party.members[i].name,file.readInt());
				SetPersonDirection(party.members[i].name,file.readString());
				personcontroller.addInputProfile(party.members[i].name,createStandardMovement(party.members[i].name,btn_UP,btn_DOWN,btn_LEFT,btn_RIGHT,btn_OK,btn_CANCEL));
				
				}
			}
		}
	
	
	file.close();
	UpdateMapEngine();
	menubg(255,0,10,undefined);
	
	}


function GameFilePreview(tmpp,tmpz,tmpn,tmph,tmpt,tmpgt,tmpparty){
	this.path=tmpp;
	this.zylia=tmpz;
	this.name=tmpn;
	this.hash=tmph;
	this.time=tmpt;
	this.gametime=tmpgt;
	this.party=tmpparty;
	}

function CreateMasterFile(game_array,filename){
	var crf= new CryptRawFile();
	crf.open(filename,true);
	crf.write(game_array.length);
	for(var i=0;i<game_array.length;i++){
		crf.write(game_array[i].path);
		crf.write(game_array[i].zylia);
		crf.write(game_array[i].name);
		crf.write(game_array[i].hash);
		crf.write(game_array[i].time);
		crf.write(game_array[i].gametime);
		crf.write(game_array[i].party);
		
		}
	crf.close();
	}

function FileDialog (background,save) {
  
  
  
  var games= new Array();
  
  SystemLoadingScreen(50,"loading gamefiles",background);
  var masterfile = new CryptRawFile();
   
  
  masterfile.open("f_master.dat",false);
  var filesize=masterfile.readInt();
  if (filesize==-1)filesize=0;
  for(var i=0;i<filesize;i++){
		games.push(new GameFilePreview(masterfile.readString(),masterfile.readInt(),masterfile.readString(),masterfile.readString(),masterfile.readString(),masterfile.readInt(),masterfile.readString()));
		if(HashFromFile("../other/"+games[games.length-1].path)!=games[games.length-1].hash){
			games.pop();
			filesize--;
			}
		}
	masterfile.close();
	
	SystemLoadingScreen(75,"loading gamefiles",background);
  var tmpcheck=true;
  var tmpimg=background;
  var tmpstart=0;
  var tmpend=games.length;
  var tmpcur=0;
  var tmpmode=0;
  var tmpa=true;
  var tmpv=0;
  var tmpoldmode=0;
  var tmpshowdelay=0;
  var tmpalpha=0;
  
  var tmpmask= CreateColor(255,255,255,255);
  SystemLoadingScreen(100,"loading gamefiles",background);
  
  background=ComputeBackground(3,2,background,true);
  langmodule.setMode("system");
  if(save)
		textarr=new Array(langmodule.getString("S_FILE_OVERWRITE"),
											langmodule.getString("S_FILE_NEWSTATE"),
											langmodule.getString("S_FILE_CANCEL")
											);
	else
		textarr=new Array(langmodule.getString("S_FILE_LOAD"),
											langmodule.getString("S_FILE_NEWGAME"),
											langmodule.getString("S_FILE_CANCEL")
											);
	
	var tmp_saveState=langmodule.getString("S_FILE_SAVESTATE")
  var tmp_gametime=langmodule.getString("S_GAMETIME");
  
  langmodule.setLastMode();
  var tmp_str="";
  var tmp_nam="";
  
  var tmpparty="";
  for(var i=0;i<party.members.length;i++){
		tmpparty+=party.members[i].name+"   ["+party.members[i].Lv+"]\n";
		}
  
  while(true){
		if(tmpcheck){
			background.blit(0,0);
			
			windowm.drawWindow(10,10,200,3*font.getHeight()+10);
			windowm.drawWindow(10,40+font.getHeight()*3,200,font.getHeight()*20+10);
			windowm.drawWindow(230,10+font.getHeight(),400,300);
			
			for(var i=tmpstart;i<tmpstart+20;i++){
				
				if(i>=tmpend)break;
				}
			font.drawText(45,15,textarr[0]);
			font.drawText(45,15+font.getHeight(),textarr[1]);
			font.drawText(45,15+font.getHeight()*2,textarr[2]);
			
			tmpimg=GrabImage(0,0,GetScreenWidth(),GetScreenHeight());
			tmpcheck=false;
			}
		while(!AreKeysLeft()){
			if(tmpa)tmpv++;
			else tmpv--;
			if(tmpv>3)tmpa=false;
			if(tmpv<-3)tmpa=true;
			tmpimg.blit(0,0);
			for(var i=tmpstart;i<tmpstart+20;i++){
				if(i>=tmpend)break;
				font.drawText(45,45+font.getHeight()*(i-tmpstart+3),games[i].name);
				}
			scrollbar(true,10,40+font.getHeight()*3,200,font.getHeight()*20+10,tmpstart,19,tmpend-1,font.getHeight());
			if(tmpmode>2){
				GlobalCursor.setPos(10,45+(tmpcur+3)*font.getHeight());
				GlobalCursor.blit(tmpv,0);
				Finger.blitMask(10,10+tmpoldmode*font.getHeight(),CreateColor(255,255,255,150));
				}
			else if(tmpmode<3){
				GlobalCursor.setPos(10,10+tmpmode*font.getHeight());
				GlobalCursor.blit(tmpv,0);
				}
			if(tmpmode>2){	
				if(tmpshowdelay>0)tmpshowdelay--;
				else{
					if(tmpalpha<255)tmpalpha++;
					tmpmask.alpha=tmpalpha*3/4;
					objectsystem.image.get(zyliasystem.get(games[tmpcur+tmpstart].zylia).saveImagePath).blitMask(230,10+font.getHeight(),tmpmask);
					tmpmask.alpha=tmpalpha;
					cfont.setColorMask(tmpmask);
					cfont.drawTextBox(235,15+font.getHeight(),GetScreenWidth()-250,font.getHeight()*20-10,0,tmp_saveState+":\n\n"+zyliasystem.get(games[tmpcur+tmpstart].zylia).location_name+"\n\n"+tmp_gametime+": "+Math.floor(games[tmpcur+tmpstart].gametime/3600000)+":"+Math.floor(games[tmpcur+tmpstart].gametime/60000)%60+"\n\n"+games[tmpcur+tmpstart].party);
					}	
				}
			FlipScreenFps();
			}
		while(AreKeysLeft()){
			switch(GetKey()){
				case KEY_UP:{
					if(tmpmode>0&&tmpmode<3)tmpmode--;
					else{
						if(tmpcur+tmpstart>0){
							tmpcur--;
							tmpshowdelay=50;
							tmpalpha=0;
							}
						if(tmpcur<0){
							tmpstart--;
							tmpcur++;
							}
						}
					break;
					}
				case KEY_DOWN:{
					if(tmpmode<2)tmpmode++;
					else{
						if(tmpcur+tmpstart<tmpend-1){
							tmpcur++;
							tmpshowdelay=50;
							tmpalpha=0;
							}
						if(tmpcur>19){
							tmpstart++;
							tmpcur--;
							}
						}
					break;
					}
				case btn_OK:{
					var tmpdate= new Date();
					switch(tmpmode){
						case 0: if(filesize>0){tmpoldmode=tmpmode; tmpmode=3;} break;
						case 1:{
							if(save){
								
								SaveGame("datei_"+filesize+".dat");
								
								
								
								tmp_nam=g_maincharacter+" "+tmpdate.getHours()+":"+tmpdate.getMinutes();
								
								games.push(new GameFilePreview("datei_"+filesize+".dat",g_saveStateZyliaID,tmp_nam,HashFromFile("../other/datei_"+filesize+".dat"),tmpdate.getDate(),GetTime()-startTime,tmpparty));
								
								CreateMasterFile(games,"f_master.dat");
								return false;
								}
							else{
								Neu(tmpimg);
								return true;
								}
							break;
							}
						case 2:return false; break;
						case 3:{
							if(save){
								SaveGame(games[tmpcur+tmpstart].path);
								
								tmp_nam=g_maincharacter+" "+tmpdate.getHours()+":"+tmpdate.getMinutes();
								
								games[tmpcur+tmpstart] = new GameFilePreview(games[tmpcur+tmpstart].path,g_saveStateZyliaID,tmp_nam,HashFromFile("../other/"+games[tmpcur+tmpstart].path),tmpdate.getDate(),GetTime()-startTime,tmpparty)
								
								
								CreateMasterFile(games,"f_master.dat");
								return false;
								}
							else{
								tmpmask=CreateColor(255,255,255,255);
								
								while(tmpmask.alpha>0){
									tmpimg.blitMask(0,0,tmpmask);
									menubg_s(255-tmpmask.alpha);
									FlipScreenFps()
									
									tmpmask.alpha=Math.max(0,tmpmask.alpha-20);
									}
								renderscript.add("LoadFrame","menubg_s(255);");
								SetDelayScript(0,"renderscript.del(\"LoadFrame\");LoadGame(\""+games[tmpcur+tmpstart].path+"\")");
								return true;
								}
							return false;
							break;
							}
						default: break;
						}
					break;
					}
				case btn_CANCEL:{
					if(tmpmode<3)return false;
					else tmpmode=tmpoldmode;
					tmpshowdelay=50;
					tmpalpha=0;
					break;
					}
				default:break;
				}
			}
		}
	}
	
//////////////////////////////////////////////////////////
function encryptString(string,key){
	var output="";
	var keypointer=0;
	for(var i=0;i<string.length;i++){
		output+=Math.floor(string.charCodeAt(i)+key.charCodeAt(keypointer)/2);
		keypointer++;
		if(keypointer>=key.length)keypointer=0;
		
		}
	
	return output;
	}
//////////////////////////////////////////////////////////
function Load () {
   var ofile = OpenFile("testsave.sav");
   
   Geld = ofile.read("Geld","Geld");
   
   for(var i=0;i<Kristall.length;i++){
      Kristall[i].menge = ofile.read("Menge von"+Kristall[i].name,Kristall[i].menge);
      }
   for(var i=0;i<Element.length;i++){
      for(var c=0;c<Char.length;c++){
         Element[i].KPin1[c] = ofile.read(Element[i].name+"KPin1 von"+Char[c].name,Element[i].KPin1[c]);
         Element[i].KPin2[c] = ofile.read(Element[i].name+"KPin2 von"+Char[c].name,Element[i].KPin2[c]);
         Element[i].KPin3[c] = ofile.read(Element[i].name+"KPin3 von"+Char[c].name,Element[i].KPin3[c]);
         }
      }   
   for(var i=0;i<Item.length;i++){
      Item[i].menge = ofile.read("Menge von "+Item[i].name,Item[i].menge);
      }
   for(var i=0;i<Waffe.length;i++){
      Waffe[i].menge = ofile.read("Menge von "+Waffe[i].name,Waffe[i].menge);
      }
   for(var i=0;i<Body.length;i++){
      Body[i].menge = ofile.read("Menge von "+Body[i].name,Body[i].menge);
      }
   for(var i=0;i<Helm.length;i++){
      Helm[i].menge = ofile.read("Menge von "+Helm[i].name,Helm[i].menge);
      }
   for(var i=0;i<Schuh.length;i++){
      Schuh[i].menge = ofile.read("Menge von "+Schuh[i].name,Schuh[i].menge);
      }
   for(var i=0;i<Zusatz.length;i++){
      Zusatz[i].menge = ofile.read("Menge von "+Zusatz[i].name,Zusatz[i].menge);
      }        
   for(var i=0;i<Char.length;i++){
                     
      Char[i].kopf = Helm[ofile.read("kopf v."+i,Char[i].kopf.nr)];
      Char[i].hand = Waffe[ofile.read("hand v."+i,Char[i].hand.nr)];
      Char[i].body = Body[ofile.read("body v."+i,Char[i].body.nr)];
      Char[i].zusatz = Zusatz[ofile.read("zusatz v."+i,Char[i].zusatz.nr)];
      Char[i].schuhe = Schuh[ofile.read("schuhe v."+i,Char[i].schuhe.nr)];
      
      Char[i].maxHP = ofile.read("maxHP v."+i,Char[i].maxHP);
      Char[i].maxMP = ofile.read("maxMP v."+i,Char[i].maxMP);
      Char[i].HP = ofile.read("HP v."+i,Char[i].HP);
      Char[i].MP = ofile.read("MP v."+i,Char[i].MP);
      Char[i].Lv = ofile.read("Lv v."+i,Char[i].Lv);
      Char[i].erf = ofile.read("erf v."+i,Char[i].erf);
      
      Char[i].angriff = ofile.read("angriff v."+i,Char[i].angriff);
      Char[i].vert = ofile.read("vert v."+i,Char[i].vert);
      Char[i].schnell = ofile.read("schnell v."+i,Char[i].schnell);
      Char[i].wendig = ofile.read("wendig v."+i,Char[i].wendig);
      Char[i].zkraft = ofile.read("zkraft v."+i,Char[i].zkraft);
      Char[i].geist = ofile.read("geist v."+i,Char[i].geist);
      
      Char[i].charset = ofile.read("charset v."+i,Char[i].charset);
      Char[i].party = ofile.read("party v."+i,Char[i].party);
      }
   
   delete ofile;
   LeerItem();
   
   
   for(var i=0;i<party.members.length;i++){
      CreatePerson(party.members[i].name,party.members[i].charset,false);
      }
   
   var Map = ofile.read("Map","Map");
   BindKey(KEY_CTRL,'Spielmenu()','menuexit()');
   AttachInput(party.members[0].name);
   AttachCamera(party.members[0].name);
   SetTalkActivationKey(KEY_SPACE);
   
   ChangeMap(Map);
   for(var i=0;i<party.members.length;i++){
      SetPersonX(party.members[i].name,ofile.read("XPosition"+party.members[i].name,"XPosition"+party.members[i].name));
      SetPersonY(party.members[i].name,ofile.read("YPosition"+party.members[i].name,"YPosition"+party.members[i].name));
      }
   for(var i=1;i<party.members.length;i++){
      FollowPerson(party.members[i].name,party.members[0].name, i*30);
      } 
  

   
 
}

///////////////////////////////////////////////////////////
function inLoad(){
   for(var i=0;i<party.members.length;i++){
      DestroyPerson(party.members[i].name);
      }
   Load();
}   

///////////////////////////////////////////////////////////
function saveOptionPoints(){
	
	var file=OpenFile("options.dat");
	file.write("windowm",windowm_nr);
	file.write("language",langmodule.getLang());
	file.flush();
	file.close();
	
	}
function loadOptionPoints(){

	var file=OpenFile("options.dat");
	windowm_nr=file.read("windowm",1);
	windowm=LoadWindowStyle("menu"+windowm_nr+".rws");
	if(!file.read("definedLanguage",false)){
		LangScreen(GrabImage(0,0,640,480));
		file.write("definedLanguage",true);
		file.write("language",langmodule.getLang());
		file.flush();
		}
	if(!file.read("definedKeys",false)){
		ChangeKeys(GrabImage(0,0,640,480));
		file.write("definedKeys",true);
		}
	else langmodule.setLang(file.read("language","en"));
	file.close();
}

/////////////////////////////////////////////////////////////
function saveArray(array,name,file){
	file.write(name,array.length);
	for(var i=0;i<array.length;i++){
		file.write(name+"_"+i,array[i]);
		}
}

function loadArray(name,file){	
	var array=new Array();
	var length=file.read(name,0);
	for(var i=0;i<length;i++){
		array.push(file.read(name+"_"+i,0));
		}
	return array;
}
/////////////////////////////////////////////////////////////
//////////////////////
function CryptRawFile(){

	this.rawfile=undefined;
	this.isOpen = false;
	this.writeable = false;
}

CryptRawFile.prototype.open = function(name,wri) {
	if(wri){
		var file = OpenFile("../other/"+name);
		file.flush();
		file.close();
		}
	
	this.rawfile = OpenRawFile(name, wri);
	this.isOpen = true;
	this.writeable = wri;

}

CryptRawFile.prototype.close = function() {

	this.rawfile.close();

}

CryptRawFile.prototype.write = function(string) {
	
	if (!this.writeable || !this.isOpen) return -1;
	var byte_array = ByteArrayEncrypt(CreateByteArrayFromString(string)); 
	if(byte_array.length>255)byte_array.length=255;
	var size = CreateByteArray(1);
	size[0]=byte_array.length;
	
	this.rawfile.write(size);
	this.rawfile.write(byte_array);

}

CryptRawFile.prototype.readString = function() {
	
	if(!this.isOpen || this.rawfile.getPosition()>=this.rawfile.getSize()) return -1;
	
	var size = this.rawfile.read(1);
	
	if(this.rawfile.getPosition()>=this.rawfile.getSize()) return -1;
	
	var string = CreateStringFromByteArray(ByteArrayDecrypt(this.rawfile.read(size[0])));
	return string;

}

CryptRawFile.prototype.readInt = function() {
	
	if(!this.isOpen || this.rawfile.getPosition()>=this.rawfile.getSize()) return -1;
	
	var size = this.rawfile.read(1);
	
	if(this.rawfile.getPosition()>=this.rawfile.getSize()) return -1;
	
	var string = CreateStringFromByteArray(ByteArrayDecrypt(this.rawfile.read(size[0])));
	var integer = parseInt(string);
	return integer;
}

CryptRawFile.prototype.readFloat = function() {
	
	if(!this.isOpen || this.rawfile.getPosition()>=this.rawfile.getSize()) return -1;
	
	var size = this.rawfile.read(1);
	
	if(this.rawfile.getPosition()>=this.rawfile.getSize()) return -1;
	
	var string = CreateStringFromByteArray(ByteArrayDecrypt(this.rawfile.read(size[0])));
	var flt = parseFloat(string);
	return flt;
}

function RawTester(){
	
	var crf = new CryptRawFile();
	crf.open("rawtest.dat",true);
	crf.write(9);
	crf.write(15);
	crf.write("Das ist ein Text!! ");
	crf.close();
	
	crf.open("rawtest.dat");
	var string  =crf.readInt();
	dialog.info(string+1);
	
	string  =crf.readString();
	dialog.info(string+1);
	
	string  =crf.readString();
	dialog.info(string);
	crf.close();
	
	}
function ByteArrayEncrypt(byte_array){
	
	for(var i=0;i<byte_array.length;i++){
		
		byte_array[i]=(byte_array[i]+100)%255;
		
		}
	return byte_array;
	}
	
function ByteArrayDecrypt(byte_array){
	
	for(var i=0;i<byte_array.length;i++){
		
		byte_array[i]=(byte_array[i]+255-100)%255;
		
		}
	return byte_array;
	}